	function PLOT_PHASE_Z2(wT, Phase, Npi)
	
	% Plots the phase response for an IIR filter.
	% Npi is the number of multiples of pi for the y-axis.
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2005-05-07
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:	 
	% Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================	
	hold on;
	plot(wT, Phase,'linewidth', lw);	
	N = length(Phase);
	
	axis([0 max(wT) Npi*pi 0]);
	ylabel('{\it\Phi}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);
	%	ylabel('{\it\Delta\it\Phi}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);
	xlabel('{\it\omegaT}  [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xtick(ax,lab);	
	if Npi == -7
		ay = [-7*pi -6*pi -5*pi -4*pi -3*pi -2*pi -pi  0];
		laby = {'-7\pi';'-6\pi';' ';' ';' ';' ';'-\pi';'0'};
		text(0.35*pi,-3*pi,'{\it\Phi_2}','FontName','times','FontSize',16);
		text(0.25*pi,-5*pi,'{\it\Phi_1}','FontName','times','FontSize',16);		
	end
	if Npi == -9
		ay = [-9*pi -7*pi -6*pi -5*pi -4*pi -3*pi -2*pi -pi  0];
		laby = {'-9\pi';'-7\pi';'-6\pi';' ';' ';' ';' ';'-\pi';'0'};
		text(0.5*pi,-4*pi,'{\it\Phi_2}','FontName','times','FontSize',16);
		text(0.2*pi,-5*pi,'{\it\Phi_1}','FontName','times','FontSize',16);
		end
	if Npi == -11
		ay = [-11*pi -10*pi -9*pi -8*pi -7*pi -6*pi -5*pi -4*pi -3*pi -2*pi -pi 0];
		laby = {'-11\pi';' ';' ';' ';' ';' ';' ';;' ';;' ';' ';'-\pi';'0'};
		text(0.5*pi,-3*pi,'{\it\Phi_2}','FontName','times','FontSize',16);
		text(0.2*pi,-5*pi,'{\it\Phi_1}','FontName','times','FontSize',16);
	end	
		if Npi == -14
		ay = [-14*pi -13*pi -12*pi -11*pi -10*pi -9*pi -8*pi -7*pi -6*pi -5*pi -4*pi -3*pi -2*pi -pi  0];
		laby = {'-14\pi';' ';' ';' ';' ';' ';' ';' ';' ';' ';' ';' ';' ';'-\pi';'0'};
		text(0.5*pi,-5*pi,'{\it\Phi_2}','FontName','times','FontSize',16);
		text(0.3*pi,-7*pi,'{\it\Phi_1}','FontName','times','FontSize',16);
	end	
	ytick(ay,laby); 
	grid on;
	box on;
	
	
